"""
    Basic IO functions
"""
# basics
import csv
import pickle
from tqdm import tqdm


# ------------------------------------------------------------------------------
#   IO functions (CSV)
# ------------------------------------------------------------------------------
def load_from_csvfile(filename, item=False, pbar=False):
    csvdata = []
    with open(filename, 'r') as infile:
        csv_reader = csv.reader(infile)
        # : load w/o the progress bar
        if not pbar:
            for lidx, each_line in enumerate(csv_reader):
                # : skip the item line
                if (not lidx) and item: continue
                csvdata.append(each_line)
        # : load w. the progress bar
        else:
            for lidx, each_line in tqdm( \
                enumerate(csv_reader), desc='[load-csv]'):
                # : skip the item line
                if (not lidx) and item: continue
                csvdata.append(each_line)
    return csvdata

def store_to_csvfile2(filename, data, items=None):
    with open(filename, 'w') as outfile:
        csv_writer = csv.writer(outfile)
        # : store the 2D matrix to a csvfile
        if items: csv_writer.writerow(items)
        for each_line in data:
            csv_writer.writerow(each_line)
    # done.

def store_to_csvfile3(filename, data, items=None):
    with open(filename, 'w') as outfile:
        csv_writer = csv.writer(outfile)
        # : store the 3D matrix to a csvfile
        if items: csv_writer.writerow(items)
        for each_data in data:
            for each_line in each_data:
                csv_writer.writerow(each_line)
            csv_writer.writerow('----------')
    # done.


# ------------------------------------------------------------------------------
#   IO functions (Pickle)
# ------------------------------------------------------------------------------
def load_from_pickle(filename):
    data = None
    with open(filename, 'rb') as infile:
        data = pickle.load(infile)
    return data

def store_to_pickle(filename, data):
    with open(filename, 'wb') as outfile:
        pickle.dump(data, outfile, protocol=pickle.HIGHEST_PROTOCOL)
    # done.
